/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc2.optional;

import com.filemaker.jdbc2.optional.FMObjectFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public abstract class BaseDataSource
implements Referenceable {
    private transient PrintWriter logger;
    private String serverName = "localhost";
    private String databaseName;
    private String user;
    private String password;
    private int portNumber;

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        try {
            Connection connection = DriverManager.getConnection(this.getUrl(), string, string2);
            if (this.logger != null) {
                this.logger.println("Created a non-pooled connection for " + string + " at " + this.getUrl());
            }
            return connection;
        }
        catch (SQLException sQLException) {
            if (this.logger != null) {
                this.logger.println("Failed to create a non-pooled connection for " + string + " at " + this.getUrl() + ": " + sQLException);
            }
            throw sQLException;
        }
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public void setLoginTimeout(int n) throws SQLException {
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logger;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logger = printWriter;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        this.serverName = string == null || string.equals("") ? "localhost" : string;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public abstract String getDescription();

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int n) {
        this.portNumber = n;
    }

    private String getUrl() {
        return "jdbc:filemaker://" + this.serverName + (this.portNumber == 0 || this.portNumber == 2399 ? "" : ":" + this.portNumber) + "/" + this.databaseName;
    }

    protected Reference createReference() {
        return new Reference(this.getClass().getName(), FMObjectFactory.class.getName(), null);
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = this.createReference();
        reference.add(new StringRefAddr("serverName", this.serverName));
        if (this.portNumber != 0) {
            reference.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        }
        reference.add(new StringRefAddr("databaseName", this.databaseName));
        if (this.user != null) {
            reference.add(new StringRefAddr("user", this.user));
        }
        if (this.password != null) {
            reference.add(new StringRefAddr("password", this.password));
        }
        return reference;
    }

    protected void writeBaseObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.serverName);
        objectOutputStream.writeObject(this.databaseName);
        objectOutputStream.writeObject(this.user);
        objectOutputStream.writeObject(this.password);
        objectOutputStream.writeInt(this.portNumber);
    }

    protected void readBaseObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.serverName = (String)objectInputStream.readObject();
        this.databaseName = (String)objectInputStream.readObject();
        this.user = (String)objectInputStream.readObject();
        this.password = (String)objectInputStream.readObject();
        this.portNumber = objectInputStream.readInt();
    }

    static {
        try {
            Class.forName("com.filemaker.jdbc.Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("unable to load FileMaker driver");
        }
    }
}

